<?php header("Content-type: text/css"); 
	include '../../../../wp-load.php';
	
	$json_file = file_get_contents("../admin/js/color-scheme.json");
	$json_data = json_decode($json_file, true);
	
	$json_fonts_file = file_get_contents("../admin/js/font-list.json");
	$json_fonts_data = json_decode($json_fonts_file, true);
	
	$key = 'default';
	
	function curly_brightness($hexStr) {
		$hexStr = preg_replace("/[^0-9A-Fa-f]/", '', $hexStr); 
		$rgbArray = array();
		if (strlen($hexStr) == 6) { 
			$colorVal = hexdec($hexStr);
			$rgbArray['red'] = 0xFF & ($colorVal >> 0x10);
			$rgbArray['green'] = 0xFF & ($colorVal >> 0x8);
			$rgbArray['blue'] = 0xFF & $colorVal;
		} elseif (strlen($hexStr) == 3) {
			$rgbArray['red'] = hexdec(str_repeat(substr($hexStr, 0, 1), 2));
			$rgbArray['green'] = hexdec(str_repeat(substr($hexStr, 1, 1), 2));
			$rgbArray['blue'] = hexdec(str_repeat(substr($hexStr, 2, 1), 2));
		} else {
			return false;
		}
		return (($rgbArray['red']*299) + ($rgbArray['green']*587) + ($rgbArray['blue']*114))/1000;
	}
	
	function curly_contrast($color, $test1, $test2) {
		return (abs(curly_brightness($test1) - curly_brightness($color)) > abs(curly_brightness($test2) - curly_brightness($color))) ? $test1 : $test2;
	}
	
	function curly_hex2rgb($hex) {
	   $hex = str_replace("#", "", $hex);
	
	   if(strlen($hex) == 3) {
	      $r = hexdec(substr($hex,0,1).substr($hex,0,1));
	      $g = hexdec(substr($hex,1,1).substr($hex,1,1));
	      $b = hexdec(substr($hex,2,1).substr($hex,2,1));
	   } else {
	      $r = hexdec(substr($hex,0,2));
	      $g = hexdec(substr($hex,2,2));
	      $b = hexdec(substr($hex,4,2));
	   }
	   $rgb = array($r, $g, $b);
	   return implode(",", $rgb);
	}
	
	function curly_darken($color, $dif=20){
	 
	    $color = str_replace('#', '', $color);
	    if (strlen($color) != 6){ return '000000'; }
	    $rgb = '';
	 
	    for ($x=0;$x<3;$x++){
	        $c = hexdec(substr($color,(2*$x),2)) - $dif;
	        $c = ($c < 0) ? 0 : dechex($c);
	        $rgb .= (strlen($c) < 2) ? '0'.$c : $c;
	    }
	 
	    return '#'.$rgb;
	}

/*	Font Sizes
	================================================= */
	
	$font_size_body = get_option(THEMEPREFIX.'_fonts_size_body', 14);
	$font_size_h1 = get_option(THEMEPREFIX.'_fonts_size_h1', 36);
	$font_size_h2 = get_option(THEMEPREFIX.'_fonts_size_h2', 36); 
	$font_size_h3 = get_option(THEMEPREFIX.'_fonts_size_h3', 24); 
	$font_size_h4 = get_option(THEMEPREFIX.'_fonts_size_h4', 18); 
	$font_size_h5 = get_option(THEMEPREFIX.'_fonts_size_h5', 15); 
	$font_size_h6 = get_option(THEMEPREFIX.'_fonts_size_h6', 15); 
	$font_size_highlighted = $font_size_body * 2 ;
	$font_size_menu = get_option(THEMEPREFIX.'_fonts_size_menu', 16);

/*	Colors
	================================================= */
	
	$color_menu = get_option(THEMEPREFIX.'_color_menu_bg_top', $json_data[$key]['menuBg']);
	$color_menu_link = get_option(THEMEPREFIX.'_color_menu_text', $json_data[$key]['menuLink']);
	$color_menu_hover = get_option(THEMEPREFIX.'_color_menu_hover_text', $json_data[$key]['menuHover']);
	$color_submenu = get_option(THEMEPREFIX.'_color_menu_submenu', $json_data[$key]['submenuBg']); 
	$color_submenu_link = get_option(THEMEPREFIX.'_color_submenu_text', $json_data[$key]['submenuLink']); 
	$color_submenu_hover = get_option(THEMEPREFIX.'_color_submenu_hover_text', $json_data[$key]['submenuHover']);
	$color_footer_text = get_option(THEMEPREFIX.'_footer_text_color', $json_data[$key]['footerText']);
	$color_footer_link = get_option(THEMEPREFIX.'_footer_link_color', $json_data[$key]['footerLink']);
	$color_footer_title = get_option(THEMEPREFIX.'_footer_title_color', $json_data[$key]['footerTitle']);
	$color_primary = get_option(THEMEPREFIX.'_color_primary', $json_data[$key]['primary']);
	$color_text = get_option(THEMEPREFIX.'_color_text', $json_data[$key]['text']);
	$color_link = get_option(THEMEPREFIX.'_color_links', $json_data[$key]['link']);
	$color_hover = get_option(THEMEPREFIX.'_color_links_hover', $json_data[$key]['linkHover']);
	$body_bg_color = get_option(THEMEPREFIX.'_bg_color', $json_data[$key]['background']);

/*	Load Background
	================================================= */
	
	$bg_pattern = get_option(THEMEPREFIX.'_bg_pattern', 11) ;
	$bg_image = get_option(THEMEPREFIX.'_bg_image') ;
	$bg_repeat = get_option(THEMEPREFIX.'_bg_repeat') ;
	$bg_position = get_option(THEMEPREFIX.'_bg_position') ;
	$bg_fixed = get_option(THEMEPREFIX.'_bg_fixed') ;
	
	switch($bg_pattern){
		case 1  : $bg_pat = 'bg-01.jpg'; $bg_pat_retina = 'bg-01@2X.jpg'; $bg_pat_size = '500px 333px'; break;
		case 2  : $bg_pat = 'bg-02.png'; $bg_pat_retina = 'bg-02@2X.png'; $bg_pat_size = '16px 16px'; break;
		case 3  : $bg_pat = 'bg-03.jpg'; $bg_pat_retina = 'bg-03@2X.jpg'; $bg_pat_size = '500px 500px'; break;
		case 4  : $bg_pat = 'bg-04.jpg'; $bg_pat_retina = 'bg-04@2X.jpg'; $bg_pat_size = '188px 188px'; break;
		case 5  : $bg_pat = 'bg-05.jpg'; $bg_pat_retina = 'bg-05@2X.jpg'; $bg_pat_size = '250px 250px'; break;
		case 6  : $bg_pat = 'bg-06.jpg'; $bg_pat_retina = 'bg-06@2X.jpg'; $bg_pat_size = '588px 375px'; break;
		case 7  : $bg_pat = 'bg-07.jpg'; $bg_pat_retina = 'bg-07@2X.jpg'; $bg_pat_size = '200px 200px'; break;
		case 8  : $bg_pat = 'bg-08.jpg'; $bg_pat_retina = 'bg-08@2X.jpg'; $bg_pat_size = '304px 306px'; break;
		case 9  : $bg_pat = 'bg-09.jpg'; $bg_pat_retina = 'bg-09@2X.jpg'; $bg_pat_size = '400px 343px'; break;
		case 10 : $bg_pat = 'bg-10.jpg'; $bg_pat_retina = 'bg-10@2X.jpg'; $bg_pat_size = '50px 197px'; break;
		case 11 : $bg_pat = 'bg-11.jpg'; $bg_pat_retina = 'bg-11@2X.jpg'; $bg_pat_size = '50px 197px'; break;
	}

/*	Load Fonts
	================================================= */
	
	$fonts_body					=	$json_fonts_data[get_option(THEMEPREFIX.'_fonts_body', 0)][1];
	$fonts_h1					=	$json_fonts_data[get_option(THEMEPREFIX.'_fonts_h1', 0)][1];
	$fonts_h2					=	$json_fonts_data[get_option(THEMEPREFIX.'_fonts_h2', 0)][1];
	$fonts_h3					=	$json_fonts_data[get_option(THEMEPREFIX.'_fonts_h3', 0)][1];
	$fonts_h4					=	$json_fonts_data[get_option(THEMEPREFIX.'_fonts_h4', 0)][1];
	$fonts_h5					=	$json_fonts_data[get_option(THEMEPREFIX.'_fonts_h5', 0)][1];
	$fonts_h6					=	$json_fonts_data[get_option(THEMEPREFIX.'_fonts_h6', 0)][1];
	$fonts_menu					=	$json_fonts_data[get_option(THEMEPREFIX.'_fonts_menu', 0)][1];
	$fonts_blockquote			=	$json_fonts_data[get_option(THEMEPREFIX.'_fonts_blockquotes', 0)][1];
	
/*	Custom Fonts
	================================================= */
	
	$woff						=		get_option(THEMEPREFIX.'_font_upload_woff');
	$ttf						=		get_option(THEMEPREFIX.'_font_upload_ttf');
	$svg						=		get_option(THEMEPREFIX.'_font_upload_svg');
	$eot						=		get_option(THEMEPREFIX.'_font_upload_eot');

	if($woff && $ttf && $svg && $eot) : ?>
	@font-face {
		font-family: 'Custom Uploaded Font';
		src: url('<?php echo $eot; ?>');
		src:
			<?php if(strpos($_SERVER['HTTP_USER_AGENT'], 'Chrome') !== false): ?>
			url('<?php echo $woff; ?>') format('woff'),
			<?php endif; ?>
			url('<?php echo $eot; ?>?#iefix') format('embedded-opentype'),
			url('<?php echo $svg; ?>#Custom%20Uploaded%20Font') format('svg'),
			<?php if(strpos($_SERVER['HTTP_USER_AGENT'], 'Chrome') == false): ?>
			url('<?php echo $woff; ?>') format('woff'),
			<?php endif; ?>
			url('<?php echo $ttf; ?>') format('truetype');
		font-weight: normal;
		font-style: normal;
	}
<?php endif; ?>

/*	General
	================================================= */
	
body{
	background-color:		<?php echo $body_bg_color ?>;
	<?php if($bg_pattern == 0) : ?>
	<?php echo ($bg_image) ? 'background-image: url('.$bg_image.');' : null; ?>
	<?php echo ($bg_repeat) ? 'background-repeat: '.$bg_repeat.';' : null; ?>
	<?php echo ($bg_position) ? 'background-position: '.$bg_position.';' : null; ?>
	<?php echo ($bg_fixed == 'true') ? 'background-attachment: fixed;' : null; ?>
	<?php else : ?>
	background: url('../images/bg/<?php echo $bg_pat ?>') repeat ;
	<?php endif; ?>
}
body a,
a:visited,
a.btn-link,
a.btn-link:visited{
	color: <?php echo $color_link ?>;
}
a:hover,
a.btn-link:hover{
	color: <?php echo $color_hover ?>;
}
.btn-link{
	border: 2px solid <?php echo $color_link ?>;
}
.btn-link:hover{
	border: 2px solid <?php echo $color_hover ?>;
}
<?php if(get_option(THEMEPREFIX.'_general_wide') && get_option(THEMEPREFIX.'_general_wide') != "true") : ?>
.site{
	max-width: 1200px;
	<?php echo (get_option(THEMEPREFIX.'_general_align') == "true") ? 'margin: 0' : 'margin: 0 auto'; ?>
}
.site .stickit,
.site header,
.site footer::before{
	max-width: 1200px
}
<?php endif; ?>


/*	Header
	================================================= */
#header{
	color: <?php echo curly_contrast(get_option(THEMEPREFIX.'_header_shading_color', '#000000'), '#FFFFFF', '#000000') ?>;
}
#header-holder{
	background-color: rgba( <?php echo curly_hex2rgb(get_option(THEMEPREFIX.'_header_shading_color', '#000000')); ?> , <?php echo (get_option(THEMEPREFIX.'_header_shading_opacity', 55) / 100) ?>);
	<?php 
		switch (get_option(THEMEPREFIX.'_header_shading_pattern', 1)) {
			case 0 : $shading_img = 'bg-header-none.png'; break;
			case 1 : $shading_img = 'bg-header.png'; break;
			case 2 : $shading_img = 'bg-header-02.png'; break;
			case 3 : $shading_img = 'bg-header-03.png'; break;
			case 4 : $shading_img = 'bg-header-04.png'; break;
			default: $shading_img = 'bg-header.png';
		}
	?>
	background-image: url('../images/header/<?php echo $shading_img ?>');
}	
#header .logo{
	margin: <?php echo get_option(THEMEPREFIX.'_header_margin_top') ?>px 0 <?php echo get_option(THEMEPREFIX.'_header_margin_bottom') ?>px 0;
}
#header #navigation{
	background: <?php echo $color_menu; ?>
}

#navigation a{ color: <?php echo $color_menu_link ?> }
#navigation ul ul{ background: <?php echo $color_submenu ?>; border-left: 5px solid rgba( <?php echo curly_hex2rgb($color_submenu_link); ?>, .2);}
#navigation ul ul a{
	color: <?php echo $color_submenu_link ?>;
	border-bottom: 1px solid rgba( <?php echo curly_hex2rgb($color_submenu_link); ?>, .1);
}
#navigation ul ul a:hover{
	color: <?php echo $color_submenu_hover ?>;
}
#navigation > div > ul > li.current-menu-item > a,
#navigation > div > ul > li.current_page_ancestor > a,
#navigation > div > ul > li.current_page_parent > a{
	color: <?php echo  $color_menu_hover; ?>
}
#navigation > div > ul > li.current-menu-item > a:after,
#navigation > div > ul > li.current_page_ancestor > a:after,
#navigation > div > ul > li.current_page_parent > a:after{
	color: <?php echo $color_menu ?>;
}


/*	Footer
	================================================= */
<?php 	$footer_bg_image = get_option(THEMEPREFIX.'_bg_footer_image', null);
		$footer_bg_repeat = get_option(THEMEPREFIX.'_bg_footer_repeat', null);
		$footer_bg_position = get_option(THEMEPREFIX.'_bg_footer_position', null);
		$footer_bg = get_option(THEMEPREFIX.'_footer_bg_color', null);
?>	
footer{
	padding: <?php echo get_option(THEMEPREFIX.'_footer_margin', 40) ?>px 0 <?php echo get_option(THEMEPREFIX.'_footer_margin_bottom', 60) ?>px 0;
	color: <?php echo $color_footer_text ?>;
	
	<?php if ($footer_bg) : ?>
	background-color: <?php echo $footer_bg; ?>;
	background-image: none;
	<?php endif; ?>
	
	<?php if ($footer_bg_image) : ?>
	background-image:url('<?php echo $footer_bg_image; ?>');
	<?php endif; ?>
	
	<?php if ($footer_bg_image) : ?>
	background-repeat: <?php echo $footer_bg_repeat; ?>;
	<?php endif; ?>
	
	<?php if ($footer_bg_image) : ?>
	background-position: <?php echo $footer_bg_repeat; ?>;
	<?php endif; ?>
}
footer a, footer a:visited{ color: <?php echo $color_footer_text ?> }
footer a:hover{ color: rgba( <?php echo curly_hex2rgb($color_footer_link) ?> , 6) }
footer h5{ color: <?php echo $color_footer_title ?>}
footer .special-title{ border-color: rgba( <?php echo curly_hex2rgb($color_footer_text); ?> , .3)}

footer::before{
	margin-top: <?php echo (-(int)(get_option(THEMEPREFIX.'_footer_margin', 40)) - 50) ?>px;
	<?php if ($footer_bg_image || $footer_bg) : ?>
	display: none;
	<?php endif; ?>
}
.footer + .absolute-footer .col-lg-12:first-child{
	border-top: 1px solid rgba( <?php echo curly_hex2rgb($color_footer_text) ?> , .3);
	padding-top: 40px;
	margin-top: 10px;
}
.pre-footer{
	background: rgba( <?php echo curly_hex2rgb($color_text) ?> , .07);
}

#back-top a{
	background: rgba( <?php echo curly_hex2rgb($color_text) ?> , .8);
	color: <?php echo curly_contrast($color_text, '#000000', '#FFFFFF') ?>
}
#back-top a:hover{
	background: <?php echo $color_text ?>;
}

/*	Typography
	================================================= */	

body, ul, li, p, input, textarea, select{
	font-family: <?php echo $fonts_body ?>, sans-serif;
	font-size: <?php echo $font_size_body; ?>px;
	line-height: <?php echo ceil(($font_size_body * 1.5)) ?>px;
	<?php echo curly_get_font_style(get_option(THEMEPREFIX.'_fonts_style_body')); ?>;
}
h1{
	font-family: <?php echo $fonts_h1 ?>, sans-serif;
	font-size: <?php echo ($font_size_h1); ?>px;
	line-height: <?php echo ceil($font_size_h1 * 1.2); ?>px;
	<?php echo curly_get_font_style(get_option(THEMEPREFIX.'_fonts_style_h1')); ?>
	<?php echo curly_get_font_variant(get_option(THEMEPREFIX.'_fonts_variant_h1')); ?>
}
h2{
	font-family: <?php echo $fonts_h2 ?>, sans-serif;
	font-size: <?php echo ceil($font_size_h2); ?>px;
	line-height: <?php echo ceil($font_size_h2 * 1.2); ?>px;
	<?php echo curly_get_font_style(get_option(THEMEPREFIX.'_fonts_style_h2')); ?>
	<?php echo curly_get_font_variant(get_option(THEMEPREFIX.'_fonts_variant_h2')); ?>
}
h3{
	font-family: <?php echo $fonts_h3 ?>, sans-serif;
	font-size: <?php echo ceil($font_size_h3); ?>px;
	line-height: <?php echo ceil($font_size_h3 * 1.2); ?>px;
	<?php echo curly_get_font_style(get_option(THEMEPREFIX.'_fonts_style_h3')); ?>
	<?php echo curly_get_font_variant(get_option(THEMEPREFIX.'_fonts_variant_h3')); ?>
}
h4{
	font-family: <?php echo $fonts_h4 ?>, sans-serif;
	font-size: <?php echo ceil($font_size_h4); ?>px;
	line-height: <?php echo ceil($font_size_h4 * 1.35); ?>px;
	<?php echo curly_get_font_style(get_option(THEMEPREFIX.'_fonts_style_h4')); ?>
	<?php echo curly_get_font_variant(get_option(THEMEPREFIX.'_fonts_variant_h4')); ?>
}
h5{
	font-family: <?php echo $fonts_h5 ?>, sans-serif;
	font-size: <?php echo ceil($font_size_h5); ?>px;
	line-height: <?php echo ceil($font_size_h5 * 1.35); ?>px;
	<?php echo curly_get_font_style(get_option(THEMEPREFIX.'_fonts_style_h5')); ?>
	<?php echo curly_get_font_variant(get_option(THEMEPREFIX.'_fonts_variant_h5')); ?>
}
h6{
	font-family: <?php echo $fonts_h6 ?>, sans-serif;
	font-size: <?php echo ceil($font_size_h6); ?>px;
	line-height: <?php echo ceil($font_size_h6 * 1.35); ?>px;
	<?php echo curly_get_font_style(get_option(THEMEPREFIX.'_fonts_style_h6')); ?>
	<?php echo curly_get_font_variant(get_option(THEMEPREFIX.'_fonts_variant_h6')); ?>
}
#navigation li a{
	font-family: <?php echo $fonts_menu ?>, sans-serif;
	font-size: <?php echo $font_size_menu; ?>px;
	line-height: <?php echo ceil($font_size_menu * 1.5); ?>px;
}
#navigation li li a{
	font-size: <?php echo ceil($font_size_menu*0.9); ?>px;
	line-height: <?php echo ceil($font_size_menu * 1.5); ?>px;
}
blockquote{
	font-family: <?php echo $fonts_blockquote ?>, sans-serif;
	font-size: <?php echo ceil($font_size_body * 1.2) ?>px;
	line-height: <?php echo ceil($font_size_body * 1.5 * 1.2); ?>px;
}
.btn, .btn-link,
input[type="button"],
input[type="submit"]{
	font-family: <?php echo $fonts_menu ?>, sans-serif;
}

/*	Theme Features
	================================================= */
.special-title{ border-color: rgba( <?php echo curly_hex2rgb($color_text) ?> , .2)}
.special-title:after{ border-color: <?php echo $color_primary ?>}

/*	Shortcodes
	================================================= */

/*	Shortcodes - Accordion
	================================================= */
.panel{
	border-bottom: 1px solid rgba( <?php echo curly_hex2rgb($color_text) ?> , .15);
}
footer .panel{
	border-bottom: 1px solid rgba( <?php echo curly_hex2rgb($color_footer_text); ?> , .15);
}

/*	Shortcodes - Button
	================================================= */
.btn,
.btn:visited,
input[type="button"],
input[type="submit"]{
	background: <?php echo $color_primary ?>;
	color: <?php echo curly_contrast($color_primary, '#000000', '#FFFFFF') ?>;
}
.btn:hover,
input[type="button"]:hover,
input[type="submit"]:hover{
	background: <?php echo curly_darken($color_primary) ?>;
	color: <?php echo curly_contrast(curly_darken($color_primary), '#000000', '#FFFFFF') ?>;
}

/*	Shortcodes - Action Boxes
	================================================= */
.action-box{
	background: rgba( <?php echo curly_hex2rgb($color_text) ?> , .075);
}

/*	Shortcodes - Event Agenda
	================================================= */
.event-agenda .row{
	border-bottom: 1px solid rgba( <?php echo curly_hex2rgb($color_text) ?> , .15);
}
.event-agenda .row:hover{
	background: rgba( <?php echo curly_hex2rgb($color_text) ?> , .05);
}


/*	Shortcodes - Box
	================================================= */
.well{
	border-top: 3px solid rgba(<?php echo curly_hex2rgb($color_text) ?>, .25);
}
/*	Shortcodes - Slider
	================================================= */
.carousel .carousel-control{
	background: rgba(<?php echo curly_hex2rgb($color_text) ?>, .45);
}

/*	Shortcodes - Divider
	================================================= */
.divider.one				{ border-top: 1px solid rgba( <?php echo curly_hex2rgb($color_text) ?> , .25); height: 1px; }
.divider.two				{ border-top: 1px dotted rgba( <?php echo curly_hex2rgb($color_text) ?> , .25); height: 1px; }
.divider.three				{ border-top: 1px dashed rgba( <?php echo curly_hex2rgb($color_text) ?> , .25); height: 1px; }
.divider.four				{ border-top: 3px solid rgba( <?php echo curly_hex2rgb($color_text) ?> , .25); height: 1px; }
.divider.fire				{ border-top: 1px solid rgba( <?php echo curly_hex2rgb($color_text) ?> , .25); height: 1px; }

/*	Shortcodes - Tabs
	================================================= */
.nav-tabs{
	border-bottom: 1px solid rgba( <?php echo curly_hex2rgb($color_text) ?> , .15);
}
.nav-tabs .active>a, 
.nav-tabs .active>a:hover, 
.nav-tabs .active>a:focus{
	background: rgba( <?php echo curly_hex2rgb($color_text) ?> , .07) !important;
	color: <?php echo $color_text ?>;
}
.nav-tabs li a:hover{
	background: rgba( <?php echo curly_hex2rgb($color_text) ?> , .07);
}

/*	Shortcodes - Toggle
	================================================= */
h6[data-toggle="collapse"] i{
	color: <?php echo $color_primary ?>;
	margin-right: 10px
}

/*	Shortcodes - Progress
	================================================= */
.progress{
	height: <?php echo ( $font_size_body * 1.5 + 6); ?>px;
	line-height: <?php echo ($font_size_body * 1.5 + 6); ?>px;
}
.progress .progress-bar{
	font-size: <?php echo $font_size_body; ?>px;
	font-weight: bold;
}

/*	Shortcodes - Blockquote
	================================================= */
.blockquote:before{
	color: <?php echo $color_link ?>;
}
.blockquote cite{
	display: block;
	color: <?php echo $color_link ?>;
	font-weight:bold;
	margin-top: 10px
}
.blockquote cite:before{
	content: '\2014';
	margin-right: 10px
}
.blockquote img{
	-webkit-border-radius: 300px;
	-moz-border-radius: 300px;
	border-radius: 300px;
	margin: 0 0 10px 10px;
	border: 5px solid rgba( <?php echo curly_hex2rgb($color_text) ?> , .2);
	width: 90px;
	height: 90px
}

/*	Shortcodes - Testimonials
	================================================= */
.testimonials blockquote{
	background: <?php echo curly_darken($color_text, -200) ?>;
}
.testimonials blockquote:after{
	color: <?php echo curly_darken($color_text, -200) ?>;
}
.testimonials blockquote:before,
.testimonials cite{ color: <?php echo $color_primary ?>; }

/*	Shortcodes - Lists
	================================================= */
.list-bullets ul{list-style: none; padding: 0 0 0 20px }	
.list-bullets li:before{
	content: '\F111';
	font-family: 'FontAwesome';
	font-size: 10px;
	line-height: 1em;
	color: <?php echo $color_primary ?>;
	margin: 0 10px 0 0;
}

.list-circle ul{list-style: none; padding: 0 0 0 20px }
.list-circle li:before{
	content: '\F10C';
	font-family: 'FontAwesome';
	font-size: 10px;
	line-height: 1em;
	color: <?php echo $color_primary ?>;
	margin: 0 10px 0 0;
}

.list-square ul{list-style: none; padding: 0 0 0 20px }	
.list-square li:before{
	content: '\F0C8';
	font-family: 'FontAwesome';
	font-size: 10px;
	line-height: 1em;
	color: <?php echo $color_primary ?>;
	margin: 0 10px 0 0;
}

.list-crosslist ul{list-style: none; padding: 0 0 0 20px }
.list-crosslist	li:before{
	content: '\F00C';
	font-family: 'FontAwesome';
	line-height: 1em;
	color: <?php echo $color_primary ?>;
	margin: 0 10px 0 0;
}

.list-checklist ul{list-style: none; padding: 0 0 0 20px }
.list-checklist	li:before{
	content: '\F00C';
	font-family: 'FontAwesome';
	line-height: 1em;
	color: <?php echo $color_primary ?>;
	margin: 0 10px 0 0;
}

.list-default-list ul{list-style: none; padding: 0 0 0 20px }
.list-default-list li:before{
	content: '\F0DA';
	font-family: 'FontAwesome';
	line-height: 1em;
	color: <?php echo $color_primary ?>;
	margin: 0 10px 0 0;
}

/*	Shortcodes - Highlighted Paragraph
	================================================= */
.lead.different{
	font-family: <?php echo $fonts_blockquote; ?>, sans-serif;
}

/*	Shortcodes - Person
	================================================= */
.person img{
	border: 5px solid rgba( <?php echo curly_hex2rgb($color_text) ?> , .2);
}

/*	Shortcodes - Icons
	================================================= */
.icon-boxed{
	background-color: rgba( <?php echo curly_hex2rgb($color_text) ?> , .5);
	color: <?php echo curly_contrast($color_text, '#000000', '#FFFFFF') ?>;
}
a:hover .icon-boxed{
	background-color: <?php echo $color_link ?>;
	color: <?php echo curly_contrast($color_link, '#000000', '#FFFFFF') ?>;
}

/*	Shortcodes - Full Width Box
	================================================= */

/*	Shortcodes - Pricing Tables
	================================================= */
.wl-pricing-table .content-column{
	background-color: rgba( <?php echo curly_hex2rgb($color_text) ?> , .05);
}
.wl-pricing-table .content-column h4 *:after, 
.wl-pricing-table .content-column h4 *:before{ 
	border-top: 3px double rgba( <?php echo curly_hex2rgb($color_text) ?> , .2);
}

.wl-pricing-table.light .content-column.highlight-column{
	background-color: <?php echo $color_text ?>;
	color: <?php echo curly_contrast($color_text, '#000000', '#FFFFFF') ?>;
}
.wl-pricing-table.light .content-column.highlight-column h4 *:after, 
.wl-pricing-table.light .content-column.highlight-column h4 *:before{ 
	border-top: 3px double rgba(<?php echo curly_hex2rgb(curly_contrast($color_text, '#000000', '#FFFFFF')) ?>, .2)
}

/*	WordPress Classes
	================================================= */
.avatar{
	-webkit-border-radius: 300px;
	-moz-border-radius: 300px;
	border-radius: 300px;
}
article table td{
	border-bottom: 1px solid rgba( <?php echo curly_hex2rgb($color_text) ?>, .05);
}
article table thead  th{
	border-bottom: 4px solid <?php echo $color_primary ?>;
}    
article table tfoot td{
	border-top: 4px solid rgba( <?php echo curly_hex2rgb($color_text) ?>, .05);
}
article table tbody tr:hover td{
	background: rgba( <?php echo curly_hex2rgb($color_text) ?>, .05) !important;
}    
.bypostauthor .comment div{
	background: rgba( <?php echo curly_hex2rgb($color_text) ?>, .05);
}


/*	Blog
	================================================= */
.post-calendar-date{
	background: <?php echo curly_contrast($color_text, "#000000", '#FFFFFF') ?>;
	color: <?php echo $color_text; ?>;
}
.post-calendar-date em{
	color: <?php echo $color_primary ?>;
}
.meta-data{
	font-size: <?php echo ($font_size_body * 0.85); ?>px;
	color: <?php echo $color_link ?>;
}
.single .meta-data{
	font-size: <?php echo $font_size_body; ?>px;
}
.blog-sort{
	background: rgba( <?php echo curly_hex2rgb($color_text); ?> , .07);
}
#blog-entries .sticky{
	background: rgba( <?php echo curly_hex2rgb($color_text); ?> , .07);
	padding: 20px;
	-webkit-border-radius: 3px;
	-moz-border-radius: 3px;
	border-radius: 3px;
}
#filters a{
	color: <?php echo $color_text; ?>
}
#filters a:hover,
#filters a.active:before{
	color: <?php echo $color_link ?>;
}
.nav-links {
	color: <?php echo $color_text; ?>
}
ul.pagination > li > a,
ul.pagination > li > span{
	border-color : rgba(<?php echo curly_hex2rgb($color_text) ?>, .1);
	border-top: none;
	border-bottom: none;
	border-left: none;
	background: rgba( <?php echo curly_hex2rgb($color_text) ?> , .07);
	font-weight: bold;
	color: <?php echo $color_text ?>;
}
ul.pagination > li > a:hover{
	background: rgba( <?php echo curly_hex2rgb($color_text) ?> , .15);
}
ul.pagination > li:last-child a{
	border-right: none
}
ul.pagination > .active > a,
ul.pagination > .active > span,
ul.pagination > .active:hover > span{
	background: <?php echo $color_menu ?>;
	border-color: <?php echo $color_menu ?>;
	color: <?php echo curly_contrast($color_menu, '#000000', '#FFFFFF') ?>;
}
.tag-list span{
	color: <?php echo $color_link ?>;
}
.social-box{
	background: rgba( <?php echo curly_hex2rgb($color_text) ?> , .05);
	-webkit-border-radius: 3px;
	-moz-border-radius: 3px;
	border-radius: 3px;
}
.about-author{
	border-top: 4px solid <?php echo $color_primary ?>;
	border-bottom: 1px solid rgba( <?php echo curly_hex2rgb($color_text) ?> , .1);
}
.comment > div{
	border: 1px solid rgba( <?php echo curly_hex2rgb($color_text) ?> , .2);
	-webkit-border-radius: 3px;
	-moz-border-radius: 3px;
	border-radius: 3px;
}
#commentform input[type="submit"]{
	background: <?php echo $color_primary ?>;
	border:1px solid <?php echo $color_primary ?>;
	color: <?php echo curly_contrast($color_primary, '#000000', '#FFFFFF') ?>;
	-webkit-border-radius: 3px;
	-moz-border-radius: 3px;
	border-radius: 3px;
}
.label-format{ background: <?php echo $color_primary; ?>; color: <?php echo curly_contrast($color_primary, '#000000', '#FFFFFF') ?> }

/*	Pages - Contact
	================================================= */

/*	Widgets
	================================================= */
.custom-search-form input:after{
	content: '\F002';
}
.widget_rss li:before,
.widget_recent_entries li:before,
.widget_recent_comments li:before{
	content: '\F0DA';
	font-family: 'FontAwesome';
	line-height: 1em;
	margin: 0 5px 0 0;
}

/*	Custom Recent Posts
	================================================= */	
.recent-posts time{
	background: <?php echo curly_contrast($color_text, '#000000', '#FFFFFF') ?>;
	color: <?php echo $color_text ?>;
	-webkit-border-radius: 3px;
	-moz-border-radius: 3px;
	border-radius: 3px;
	width: 70px;
	height: 70px;
	padding: 8px 0 0 0;
	display: block;
	text-align: center;
	box-sizing: border-box;
	font-weight: normal;
}
.recent-posts time span{
	font-size: 32px;
	letter-spacing: -2px;
}
.recent-posts time em{
	display: block;
	font-style: normal;
	text-transform: uppercase;
	color: <?php echo $color_primary ?>;
	font-size: 16px;
	font-weight:bold;
}
.recent-posts img{
	-webkit-border-radius: 3px;
	-moz-border-radius: 3px;
	border-radius: 3px;
}
.recent-posts .flip-container{
	margin-right: 30px;
}
.recent-posts h6{
	line-height: <?php echo ($font_size_h6 * 1.2); ?>px;
}
.recent-posts h6 + span a{
	color: <?php echo $color_text ?>;
	font-size: <?php echo ($font_size_body * 0.85); ?>px;
} 
/* Portrait tablet to landscape and desktop */
@media (min-width: 768px) and (max-width: 979px) {
	.post-calendar-date span{
		font-size: 24px;
	}
	.post-calendar-date em{
		font-size: 14px;
	}
	aside .flip-container{
		display: none;
	}
	aside.pre-footer .flip-container{
		display: block;
	}
}	

/* Landscape phones and down */
@media (max-width: 767px) {
	.mobile-padding{
		padding-left:20px;
		padding-right:20px;
	}
	header .menu{
		display: none;
	}
	#navigation > div > ul > li{
		display: block;
		text-align: left;
		margin: 0 !important;
		border-bottom: 1px solid rgba( <?php echo curly_hex2rgb($color_menu_link); ?> , 0.2)
	}
	#navigation ul li{ position: relative }
	#navigation a{ padding: 10px 20px }
	#navigation ul ul,
	#navigation ul li:hover > ul{
		display: none;
		position: static;
		background: <?php echo curly_darken($color_menu); ?>;
		border: none;
		margin: 0 !important;
		-webkit-box-shadow: none;
		-moz-box-shadow: none;
		box-shadow: none;
		padding: 0;
	}
	#navigation ul ul li{
		margin: 0;
	}
	#navigation ul ul a{
		color: <?php echo $color_menu_link ?> !important;
		padding: 10px 20px !important;
		border-top: 1px solid rgba( <?php echo curly_hex2rgb($color_menu_link); ?> , 0.2) !important;
		border-bottom: none !important
	}
	.nav-click{
		border-left: 1px solid rgba( <?php echo curly_hex2rgb($color_menu_link); ?> , 0.2)
	}
	.menu-parent-item > a::after,
	.menu-parent-item > a::after .menu-parent-item > a::after{
		content: none !important;
	}
	#navigation > div > ul > li.current-menu-item > a:after,
	#navigation > div > ul > li.current_page_ancestor > a:after,
	#navigation > div > ul > li.current_page_parent > a:after{
		content: none;
	}
	.footer-widget{ margin-bottom:30px }
	.absolute-footer{ text-align: center }
	.pre-footer .recent-posts li{
		width: 100%;
		margin-right: 0;
	}
	.page-heading{ text-align: center }
	.page-heading h1{ float: none }
	.action-box .btn-large:first-child{
		display: none;
	}
	.event-agenda .event-agenda-day time{
		margin-top:0
	}
	.event-agenda-event.row span{ display: block }
	.event-agenda .event-agenda-day h3{
		margin-bottom: 0
	}
	.content-column{
		margin-right: 0;
		width: 100% !important;
		float: none;
		overflow: hidden;
		clear: both;
	}
	.about-author{ text-align: center; }
	.wl-pricing-table.light .highlight-column{
		margin: 0
	}
	.header-info{
		float: none;
		text-align: center;
		margin: 5px auto;
	}
	.theme-bc{ padding: 0 }
	
	a,
	a:visited,
	a.btn-link,
	a.btn-link:visited,
	*[class^="icon-"],
	*[class*=" icon-"],
	.row-fluid{
		-webkit-transition: none;
		-moz-transition: none;
		-ms-transition: none;
		-o-transition: none;
		transition: none;
	}
	
}

/*	3rd Party Integration
	================================================= */

/*	WooCommerce
	================================================= */
.woocommerce div.product .woocommerce-tabs ul.tabs li.active, 
.woocommerce-page div.product .woocommerce-tabs ul.tabs li.active{
	background: rgba( <?php echo curly_hex2rgb($color_text) ?> , .07) !important;
	color: <?php echo $color_text ?>;
}
.woocommerce .star-rating span{
	color: <?php echo $color_primary ?>;
}
@media (max-width: 767px) {
	.woocommerce ul.products li.product,
	.woocommerce-page ul.products li.product{
		width: 48% !important
	}
	.woocommerce ul.products li.product:nth-child(even),
	.woocommerce-page ul.products li.product:nth-child(even){
		margin-right: 0 !important
	}
}

/*	Custom CSS
	================================================= */
<?php if(get_option(THEMEPREFIX.'_hover_menu', 'false') != 'false') : ?>
	#menu-overlay{ display: none !important }
<?php endif; ?>
<?php echo get_option(THEMEPREFIX.'_custom_css') ?>